function [] = run_evalStrandSpecLib_1dir(dir,inputFile,avgGeneStats,flip,name)
lib = name;

%% read the raw files
sam2Mat_strandSpec_1dir(dir,inputFile,flip,name);
%% generate wig files
verbose('Generating bedGraph files',10);
mat2Wig_strandSpec_1dir(lib);
%% calculate strandness and CV stats
verbose('Calculating statistics on strandness and CV',10);
allStats_1dir(dir,lib);

%% Check the library complexity
verbose('Checking the Library''s complexity',10);
checkLibraryComplexity_1dir(dir,lib);

%% Compare expression levels
verbose('Comparing expression patterns',10);
compareExpression_1dir(dir,lib,0);

%% Find segmented genes
verbose('Finding segmented genes',10);
FindSegmentedGenes_1dir(dir,lib);

%% Compare boundaries coverage
verbose('Comparing boundaries coverage',10);
CompareBoundariesWPaired_1dir(dir,lib);

%% Calculate the average gene plots (this takes a while to run)
if (avgGeneStats)
    verbose('Calculating the average gene plot',10);
    avgGene_1dir(dir,lib,1);
end
