function [] = mat2Wig_strandSpec_1dir(name,color)
if nargin<2,
    color = '56,117,215';
end
%% load data
matFile = sprintf('%s.mat',name);
if ~exist(matFile,'file')
    error('prog:input','mat2Wig_strandSpec_1dir: mat file %s is missing. ',matFile);
end
load(matFile);
chrNum = length(DataF); 

%% normalize
NormDataFconv = cell(size(DataFconv));   %#ok<USENS>
NormDataRconv = cell(size(DataRconv));  %#ok<USENS>
sumAll = sumFconv+sumRconv;
for c=1:chrNum
   NormDataFconv{c} = DataFconv{c}./sumAll; 
   NormDataRconv{c} = DataRconv{c}./sumAll; 
end   
%% create bedGraph files
strands = {'norm.F','norm.R','F','R'};
data = {NormDataFconv,NormDataRconv,DataFconv, DataRconv};
lims = {'0:1e-6','-1e-6:0','0:100','-100:0'};
for s=1:length(strands)
    
    fN = fopen(sprintf('%s.%s.bedGraph',name,strands{s}),'w');
    verbose(sprintf('working on %s\n',strands{s}),20);
    n = sprintf('coverage %s %c',name,strands{s});
    fprintf(fN,['track type=bedGraph name="%s" '...
        'description="%s" visibility=full' ...
        ' color=%s maxHeightPixels=64:64:11 viewLimits=%s autoScale=off\n'],n, n,color,lims{s}  );
    
    D = data{s};
    
    for c=1:chrNum
        lastV=D{c}(1); lastI=1;
        ch = num2str(c);
        if c==17,
            ch = 'M';
        end
        
        for i=2:length(D{c})
            if D{c}(i)~=lastV
                if s==1
                    fprintf(fN,'chr%s %d %d %d\n',ch,lastI-1,i-1,lastV);%0 based corrdinates
                else
                    fprintf(fN,'chr%s %d %d %d\n',ch,lastI-1,i-1,-lastV);%0 based corrdinates
                end
                lastI=i;
                lastV = D{c}(i);
            end
        end
        
        if i>lastI,
            if s==1
                fprintf(fN,'chr%s %d %d %d\n',ch,lastI-1,i-1,lastV);%0 based corrdinates
            else
                fprintf(fN,'chr%s %d %d %d\n',ch,lastI-1,i-1,-lastV);%0 based corrdinates
            end
        end
    end
    fclose(fN);
end


