function [] = compareExpression_1dir(dir,lib,varargin)
%%
if length(varargin)==1,
    generateMAplot=varargin{1};
else
    generateMAplot=1;
end
matFile = sprintf('./%s.allExpression.mat',lib);

load(sprintf('%s/SGD.mat',dir));
allExp = NaN*ones(length(SGD.chr),1);

fname = sprintf('%s.mat',lib);
if ~exist(fname,'file'),
    error('prog:input','checkLibraryComplexity_1dir: File %s does not exist\n',fname);
end

load(fname,'SubFread1_ext36','SubRread1_ext36');

for g=1:length(SGD.chr)
    ch = SGD.chr(g); st = min(SGD.pos(g,:)); en = max(SGD.pos(g,:));
    ind = st:en;
    if SGD.watson(g)
        dat = SubFread1_ext36{ch};  %#ok<USENS>
    else
        dat = SubRread1_ext36{ch};  %#ok<USENS>
    end
    
    allExp(g) = mean(dat(ind));
    
end

%% pooled
load(sprintf('%s/pooled.mat',dir));
pooledExp = NaN*ones(size(SGD.chr));
for g=1:length(SGD.chr)
    ch = SGD.chr(g); st = min(SGD.pos(g,:)); en = max(SGD.pos(g,:));
    ind = st:en;
    if SGD.watson(g)
        dat = all.SubFread1_ext36{ch};
    else
        dat = all.SubRread1_ext36{ch};
    end
    
    pooledExp(g) = mean(dat(ind));
    
end
pooledExpReal = pooledExp ;
pooledExp = pooledExp./sum(pooledExp);

%%
allExpReal = allExp;

allExp = allExp./repmat(sum(allExp),length(allExp),1);
save(matFile,'allExp','pooledExp','allExpReal','pooledExpReal');

printFig = 1;
%% compare to pooled

dat1 = log2(allExp);
dat2 = log2(pooledExp);
ind = isfinite(dat1) & isfinite(dat2);
t = corrcoef(dat1(ind),dat2(ind));
allCorrToPooled = t(1,2);
allRMSEToPooled = sqrt(nanmean((dat1(ind)-dat2(ind)).^2));


%% scatter plot library vs. pooled expression
figure(1);clf
plot(dat1(ind),dat2(ind),'.');
xlabel(lib,'interpreter','none');
ylabel('Pooled Library')
title(sprintf('corr=%f',t(1,2)));
axis equal
grid
if printFig
print(gcf,'-dpng','-r300',sprintf('%s.PooledVSlib.png',lib));
end

%% Q-Q plot library vs. pooled expression

figure(2); clf;
qqplot(dat1,dat2);
xlabel(sprintf('%s quantiles',lib),'interpreter','none')
ylabel('pooled library quantiles');
grid
title(sprintf('qqplot of %s and the pooled lib',lib),'interpreter','none')
hold on
plot(-25:-5,-25:-5,'r+','linewidth',2);
hold off
set(gca,'box','off','tickdir','out')
set(gca,'Xlim',[-25 -5],'Ylim',[-25 -5]);
if printFig
print(gcf,'-dpng','-r300',sprintf('%s.PooledVSlib.qqplot.png',lib));
end

%% MA plot library vs. pooled expression
if generateMAplot
    dat1 = (allExpReal);
    dat2 = (pooledExpReal);
    warning('off','Bioinfo:mairplotZeroValues')
    mairplot(dat1, dat2, 'Normalize', true, ...
        'Type','MA','PlotOnly',true); %log2 is default
    grid
    set(gca,'box','off','tickdir','out')
    title(sprintf('MA plot of %s and the pooled lib',lib),'interpreter','none')
    if printFig
    print(gcf,'-dpng','-r300',sprintf('%s.PooledVSlib.maplot.png',lib));
end
end


%% compare to dUTP_control
load(sprintf('%s/dUTP_control_expression.mat',dir),...
    'dUTP_control_Exp','dUTP_control_ExpReal');

dat1 = log2(allExp);
dat2 = log2(dUTP_control_Exp);
ind = isfinite(dat1) & isfinite(dat2);
t = corrcoef(dat1(ind),dat2(ind));
allCorrToDUTPcontrol = t(1,2);
allRMSEToDUTPcontrol = sqrt(nanmean((dat1(ind)-dat2(ind)).^2));

%% scatter plot library vs. dUTP_control expression
figure(3);clf
plot(dat1(ind),dat2(ind),'.');
xlabel(lib,'interpreter','none');
ylabel('control Library')
title(sprintf('corr=%f',t(1,2)));
set(gca,'box','off','tickdir','out')
set(gca,'Xlim',[-25 -5],'Ylim',[-25 -5]);
grid
if printFig
    print(gcf,'-dpng','-r300',sprintf('%s.dUTP_controlVSlib.png',lib));
end

%% Q-Q plot library vs. dUTP_control expression

figure(4); clf;
qqplot(dat1,dat2);
xlabel(sprintf('%s quantiles',lib),'interpreter','none')
ylabel('Control library quantiles');
grid
title(sprintf('qqplot of %s and the control lib',lib),'interpreter','none')
hold on
plot(-25:-5,-25:-5,'r+','linewidth',2);
hold off
set(gca,'box','off','tickdir','out')
set(gca,'Xlim',[-25 -5],'Ylim',[-25 -5]);
if printFig
    print(gcf,'-dpng','-r300',sprintf('%s.dUTP_controlVSlib.qqplot.png',lib));
end

%% MA plot library vs. dUTP_control expression
if generateMAplot
    dat1 = allExpReal;
    dat2 = dUTP_control_ExpReal;
    warning('off','Bioinfo:mairplotZeroValues')
    mairplot(dat1, dat2, 'Normalize', true, ...
        'Type','MA','PlotOnly',true)
    grid
    set(gca,'box','off','tickdir','out')
    set(gca,'Xlim',[-6 10],'Ylim',[-8 8]);
    title(sprintf('MA plot of %s and the control lib',lib),'interpreter','none')
end

%% generate expression files output
load(sprintf('%s/SGD.mat',dir));

fid = fopen(sprintf('%s.ExpressionProfile.tab',lib),'w');
fprintf(fid,'Gene\tName\tAvgCounts\tFractionFromTotalReads\n');
for g=1:length(SGD.chr)
    fprintf(fid,'%s\t%s\t%.4f\t%.4e\n',SGD.acc{g},SGD.name{g},allExpReal(g),allExp(g));
end
fclose(fid);

fid = fopen('ExpressionProfile_pooled.tab','w');
fprintf(fid,'Gene\tName\tAvgCounts\tFractionFromTotalReads\n');
for g=1:length(SGD.chr)
    fprintf(fid,'%s\t%s\t%.4f\t%.4e\n',SGD.acc{g},SGD.name{g},pooledExpReal(g),pooledExp(g));
end
fclose(fid);

fid = fopen('ExpressionProfile_dUTP_control.tab','w');
fprintf(fid,'Gene\tName\tAvgCounts\tFractionFromTotalReads\n');
for g=1:length(SGD.chr)
    fprintf(fid,'%s\t%s\t%.4f\t%.4e\n',SGD.acc{g},SGD.name{g},dUTP_control_ExpReal(g), dUTP_control_Exp(g));
end
fclose(fid);


%% RNA vs DNA arrays

load(sprintf('%s/SGD.mat',dir));

dat1 = log2(allExp);
dat2 = log2(SGD.RNAvsDNAArrays(:,1)); %RNA signal
ind = isfinite(dat1) & isfinite(dat2);
t = corrcoef(dat1(ind),dat2(ind));
allCorrToRNAarrays = t(1,2);
allRMSEToRNAarrays = sqrt(nanmean((dat1(ind)-dat2(ind)).^2));

%% scatter plot library vs. RNAvsDNA array expression
figure(5);clf
plot(dat1(ind),dat2(ind),'.');
xlabel(lib,'interpreter','none');
ylabel('RNA vs RNA microarray')
title(sprintf('corr=%f',t(1,2)));
grid
if printFig
    print(gcf,'-dpng','-r300',sprintf('%s.RNAvsDNAArraysVSlib.png',lib));
end

%% Q-Q plot library vs. RNAvsDNA array expression

figure(6); clf;
qqplot(dat1,dat2);
xlabel(sprintf('%s quantiles',lib),'interpreter','none')
ylabel('RNA vs RNA microarray quantiles');
grid
title(sprintf('qqplot of %s and RNA vs RNA microarray',lib),'interpreter','none')
hold on
plot(-25:-5,-25:-5,'r+','linewidth',2);
hold off
set(gca,'box','off','tickdir','out')
set(gca,'Xlim',[-25 -5],'Ylim',[-25 -5]);
if printFig
    print(gcf,'-dpng','-r300',sprintf('%s.RNAvsDNAArraysVSlib.qqplot.png',lib));
end

%% MA plot library vs. RNAvsDNA array expression
if generateMAplot
    dat1 = allExpReal;
    dat2 = SGD.RNAvsDNAArrays(:,1);
    warning('off','Bioinfo:mairplotZeroValues')
    mairplot(dat1, dat2, 'Normalize', true, ...
        'Type','MA','PlotOnly',true)
    grid
    title(sprintf('MA plot of %s and RNA vs RNA microarray',lib),'interpreter','none')
end
%% table
fid = fopen(sprintf('%s.Expression_stats.txt',lib),'w');

mat = [allCorrToDUTPcontrol allRMSEToDUTPcontrol allCorrToPooled allRMSEToPooled allCorrToRNAarrays allRMSEToRNAarrays];
fprintf(fid,'lib\tcorr_dUTP_control\tRMSE_dUTP_control\tcorr_pooled\tRMSE_pooled\tcorr_array\tRMSE_array\n');
fprintf(fid,'%s\t%.2f\t%.2f\t%.2f\t%.2f\t%.2f\t%.2f\n',lib,mat);
fclose(fid);

%% heat map and bar plots of correlation and RMSE
%if you want to compare multiple libraries, these plots might be useful
if (0)
    %% heatmap of correlation results
    figure(7);clf reset
    mat = [allCorrToPooled allCorrToDUTPcontrol allCorrToRNAarrays];
    imagesc(mat)
    set(gca,'YTick',1,'YTickLabel',lib)
    h = colorbar;
    set(h,'position',[.9 0.1061    0.0394    0.8212])
    set(gca,'position',[0.2300    0.1100    0.6050    0.8150])
    
    set(gca,'Clim',[.7 1]);
    set(gca,'Xtick',1:3,'XtickLabel',{'Pooled','standard','RNA vs RNA Arrays'})
    title('Correlation')
    set(gcf,'paperPositionMode','manual','paperPosition',[0,0,9,5]);
    print(gcf,'-dpng','-r300',sprintf('%s.ExpressionCorrMatrixSUB.png',lib));
    
    %% bar plot of correlation results
    figure(8); clf reset;
    bar(mat')
    set(gca,'Ylim',[0 1]);
    grid
    set(gca,'Xtick',1:3,'XtickLabel',{'Pooled','standard','RNA vs RNA Arrays'})
    ylabel('correlation');
    l = legend(lib);
    set(l,'interpreter','none');
    set(l,'position',[.85 0.2061    0.0394    0.6212])
    set(gca,'position',[0.1300    0.1100    0.6050    0.8150])
    set(gcf,'paperPositionMode','manual','paperPosition',[0,0,9,5]);
    print(gcf,'-dpng','-r300',sprintf('%s.ExpressionCorrSUB.png',lib));
    
    
    %% heatmap of RMSE results
    
    figure(9);clf reset;
    mat = [allRMSEToPooled allRMSEToDUTPcontrol allRMSEToRNAarrays];
    imagesc(mat)
    set(gca,'YTick',1,'YTickLabel',lib)
    h = colorbar;
    set(h,'position',[.9 0.1061    0.0394    0.8212])
    set(gca,'position',[0.2300    0.1100    0.6050    0.8150])
    
    set(gca,'Xtick',1:3,'XtickLabel',{'Pooled','standard','RNA vs RNA Arrays'})
    set(gcf,'paperPositionMode','manual','paperPosition',[0,0,9,5]);
    title('RMSE')
    print(gcf,'-dpng','-r300',sprintf('%s.ExpressionRMSEMatrixSUB.png',lib));
    
    
    %% bar plot of RMSE results
    figure(10); clf reset;
    bar(mat')
    grid
    set(gca,'Xtick',1:3,'XtickLabel',{'Pooled','standard','RNA vs RNA Arrays'})
    ylabel('RMSE');
    l = legend(lib);
    set(l,'interpreter','none');
    set(l,'position',[.85 0.2061    0.0394    0.6212])
    set(gca,'position',[0.1300    0.1100    0.6050    0.8150])
    set(gcf,'paperPositionMode','manual','paperPosition',[0,0,9,5]);
    print(gcf,'-dpng','-r300',sprintf('%s.ExpressionRMSESUB.png',lib));
end

