function [] = avgGene_1dir(dir,lib,test)
if nargin<3,
    test = 0;
end

load(sprintf('%s/SGD.mat',dir));
load(sprintf('%s/numObj.mat',dir),'numObjF','numObjR');
N = length(SGD.chr);
indLG = ismember(SGD.status,'Verified') | ismember(SGD.status,'Uncharacterized');

marOut = 0;
marIn = 0;
verbose(sprintf('currently working on lib %s\n',lib),20);
fname = sprintf('%s.mat',lib); 
if ~exist(fname,'file'),
    error('prog:input','avgGene_1dir: File %s does not exist\n',fname);
end

load (fname,'SubFread1_ext36','SubRread1_ext36');
%look at coverage
useF = SubFread1_ext36;
useR = SubRread1_ext36;

%%
mat = NaN*ones(N,marOut+marIn+100+marOut+marIn);
indG = find(indLG)';
if test,
    indG = 1:10;
end
for g=indG
    if mod(g,1000)==0, verbose(sprintf('in gene %d\n',g),20); end
    %% check CODING region
    ch = SGD.chr(g);
    if SGD.watson(g)
        stPos = SGD.pos(g,1); enPos = SGD.pos(g,2);
    else
        stPos = SGD.pos(g,2); enPos = SGD.pos(g,1);
    end
    stPos = double(stPos);
    enPos = double(enPos);
    
    p = sort([stPos enPos]);
    indLCheckOther = p(1)-50:p(2)+50;
    
    if SGD.watson(g)
        if max(numObjF{ch}(indLCheckOther))>1, continue; end %#ok<USENS>
        indL100 = (p(1)+marIn):(p(2)-marIn);
        data = useF{ch};
        
        indLSt = (p(1)-marOut):(p(1)+marIn-1);
        indLEn = (p(2)-marIn+1):(p(2)+marOut);
        
        X = indL100;
        Y = data(indL100);
        
    else
        if max(numObjR{ch}(indLCheckOther))>1, continue; end %#ok<USENS>
        indL100 = (p(2)-marIn):-1:(p(1)+marIn);
        data = useR{ch};
        
        indLSt = (p(2)+marOut):-1:(p(2)-marIn+1);
        indLEn = (p(1)+marIn-1):-1:(p(1)-marOut);
        
        X = indL100(end:-1:1);
        Y = data(indL100);
        
    end
    res = getPercentiles(X,Y);
    mat(g,:) = [data(indLSt) res data(indLEn)];
end
m2 = mat(:,(marOut+1):(end-marOut));
m3=m2./repmat(mean(m2,2),1,size(m2,2));
avgAll = nanmean(m3); 
save(sprintf('%s.avgGene.mat',lib),'avgAll','mat');


%% plot
figure(1); clf reset
% cols = jet(64);
% cols = cols(1:64/10:end,:);
% set(gca,'colorOrder',cols);
hold on
plot(avgAll','linewidth',1.5)
l = legend(lib,'location','BestOutside');
set(l,'interpreter','none');
set(gca,'position',[ 0.0500    0.1100    0.70    0.8150])
xlabel('Percentiles of gene');
ylabel('coverage compared to the average of this gene (1)');
title('Average gene coverage')
grid
set(gcf, 'PaperPosition', [0 0 10 4], 'PaperPositionMode','manual', 'PaperSize', [10 4]);
print(gcf,'-dpng','-r300',sprintf('%s.avgGene_SUB.png',lib));

end


function res = getPercentiles (X,Y)
res = NaN*ones(1,100);
func = @(x_i) interp1(X,Y,x_i);

bin_size = (X(end)-X(1))/100;
all_x = X(1):bin_size:X(end);
for i=1:100
    res(i) = quad(func,all_x(i),all_x(i+1));
end
res = res./bin_size;
end


