function [res,CV] = allStats_1dir(dir,name)
realName = name;
fname = sprintf('%s.mat',name);
load(sprintf('%s/SGD.mat',dir))
load(sprintf('%s/numObj.mat',dir),'numObjF','numObjR');
if ~exist(fname,'file'),
    error('prog:input','allStats_1dir: File %s does not exist\n',fname);
end

%% load data
load (fname,'SubFread1','SubRread1','SubFread1_ext36','SubRread1_ext36');

use.dataF = SubFread1; %use only starting points
use.dataR = SubRread1; 


%% strandness
% go over all chromosomes, and ask how many reads match the expected
% objects on F and R.
allReads = 0;
allReadsSingleFeatures = 0;
correctReads = 0;
outsideReads = 0;
oppositeReads = 0;
for c=1:length(numObjF) %#ok<USENS>
    
    indF = numObjF{c}>0;
    indR = numObjR{c}>0; %#ok<USENS>
    indOnlyF = indF & ~indR;
    indOnlyR = indR & ~indF;
    indIntergenic = ~indF & ~indR;
    
    indSingleFeature = indOnlyF | indOnlyR | indIntergenic;
    
    allReads = allReads+sum(use.dataF{c})+sum(use.dataR{c});
    allReadsSingleFeatures = allReadsSingleFeatures + ...
        sum(use.dataF{c}(indSingleFeature)) + sum(use.dataR{c}(indSingleFeature));
    correctReads = correctReads + sum(use.dataF{c}(indOnlyF)) + sum(use.dataR{c}(indOnlyR));
    oppositeReads = oppositeReads + sum(use.dataF{c}(indOnlyR)) + sum(use.dataR{c}(indOnlyF));
    outsideReads = outsideReads + sum(use.dataF{c}(indIntergenic)) + sum(use.dataR{c}(indIntergenic));
end

res = [allReads allReadsSingleFeatures correctReads oppositeReads ...
       outsideReads];
fidS = fopen(sprintf('%s.strandnessStats.txt',name),'w');
fprintf(fidS,'name\tcorrect\topposite\toutside\toppositePercent\n');
fprintf(fidS,'%s\t%d\t%d\t%d\n',realName,res(3:5),res(4)/sum(res(3:5)));
fclose(fidS);


%% coefficient of variance
% go over all genes, and calculate their CV = std/mean
use.DataF = SubFread1_ext36;
use.DataR = SubRread1_ext36;

G = length(SGD.chr);
CV = NaN*ones(G,2);

for g=1:G
    ch = SGD.chr(g);
    
    if SGD.watson(g)
        ind = SGD.pos(g,1):SGD.pos(g,2);
        dat = use.DataF{ch}(ind);
    else
        ind = SGD.pos(g,2):SGD.pos(g,1);
        dat = use.DataR{ch}(ind);
    end
    
    meanExp = mean(dat);
    stdExp = std(dat);
    CV(g,:) = [meanExp stdExp./meanExp];
    
end
% top-50%
[sortedExp ind] = sort(CV(:,1),'descend'); %#ok<ASGLU> %sort by expression
G_half = ceil(G/2);
oneCVnum = nanmean(CV(ind(1:G_half),2));
fidC = fopen(sprintf('%s.cvStats.txt',name),'w');
fprintf(fidC,'Name\tCV\n');
fprintf(fidC,'%s\t%.5f\n',realName,oneCVnum);
fclose(fidC);

