function [] = FindSegmentedGenes_1dir(dir,lib)
%%
matFile = sprintf('%s.zeroCov.mat',lib);
load(sprintf('%s/SGD.mat',dir));

indGenes = ismember(SGD.status,'Verified') | ismember(SGD.status,'Uncharacterized');

win = 5;
verbose(sprintf('working on %s\n',lib),20);
fname = sprintf('%s.mat',lib);
if ~exist(fname,'file'),
    error('prog:input','FindSegmentedGenes_1dir: File %s does not exist\n',fname);
end

load(fname);

numZeroSegments = NaN*ones(length(SGD.chr),1);
percentZero = NaN*ones(length(SGD.chr),1);
meanCoverage = NaN*ones(length(SGD.chr),1);

use.DataF = SubFread1_ext36;
use.DataR = SubRread1_ext36;

for g=find(indGenes)'
    ch = SGD.chr(g);
    st = min(SGD.pos(g,:)); en = max(SGD.pos(g,:));
    
    if SGD.watson(g)
        dat = use.DataF{ch}(st:en);
    else
        dat = use.DataR{ch}(st:en);
    end
    
    p = -1 * ones(size(dat));
    p(dat==0)=1;
    pconv = conv(p,[-1 1]);
    from = find(pconv==-2);if p(1)==1, from=[1,from]; end; %#ok<AGROW>
    to = find(pconv==2)-1;if p(end)==1, to=[to,length(p)]; end; %#ok<AGROW>
    diff = to-from;
    
    numZeroSegments(g) = sum(diff>=win);
    meanCoverage(g) = mean(dat);
    percentZero(g) = sum(dat==0)./length(dat)*100;
    clear p pconv from to diff ch st en dat
end

load(sprintf('%s/pooledGeneDist.mat',dir));
geneDist = meanCoverage(indGenes,:)./nansum(meanCoverage);
save(matFile,'numZeroSegments','percentZero','meanCoverage','indGenes','geneDist','pooledGeneDist');
%%
mat = nansum(numZeroSegments(indGenes,:).*geneDist)';

%% write output
fid = fopen(sprintf('%s.ZeroSegments.txt',lib),'w');
fprintf(fid,'lib\tweighted average of number of segments per gene\n');
fprintf(fid,'%s\t%.2f\n',lib,1+mat);
fclose(fid);


%% plots
figure(2);clf
bar([1+mat zeros(size(mat))]');
l = legend(lib);
ylabel('weighted average of number of segments per gene');
xlabel('library');
grid on;
set(l,'interpreter','none');
set(gca,'Xlim',[0.5 2],'Xtick',[]);
set(l,'position',[ 0.6447    0.1794    0.2558    0.6302]);
title('number of segments');
print(gcf,'-dpng','-r300',sprintf('%s.zeroSegments_SUB.png',lib));

%%
figure(2); clf
%     plot(geneDist,percentZero(indGenes),'.')
plot(pooledGeneDist,percentZero(indGenes),'.')

set(gca,'Xscale','log')
title(lib,'interpreter','none');
ylabel('percent zero in gene');
set(gca,'Xlim',([10^-8 0.13]),'Ylim',[0 100]);

xlabel('relative coverage of gene (pooled lib)');

ys = smooth(pooledGeneDist,percentZero(indGenes),300,'lowess');
hold on
[sortX xi] = sort(pooledGeneDist); %#ok<ASGLU>
x_s = pooledGeneDist(xi);
y_s = ys(xi);
plot(x_s,y_s,'r','linewidth',4);


print(gcf,'-dpng','-r300',sprintf('%s.zeroCoverage_SUB_pooledXaxis.png',lib));

save(sprintf('%s.segmentedGenes_pooled',lib));

