function [] = CompareBoundariesWPaired_1dir(dir,lib)
%%
matFile = sprintf('%s.boundaries.mat',lib);

load (sprintf('%s/SGD.mat',dir));
load(sprintf('%s/chrLen.mat',dir),'chromLengths');

%% make pairs dataSets
Covered3conv = NaN*ones(length(SGD.chr),1);
Covered5conv = NaN*ones(length(SGD.chr),1);

indGenes = ismember(SGD.status,'Verified') | ismember(SGD.status,'Uncharacterized');
    
winHalf = 5;
verbose(sprintf('working on %s\n',lib),20);
fname = sprintf('%s.mat',lib);
if ~exist(fname,'file'),
    error('prog:input','FindSegmentedGenes_1dir: File %s does not exist\n',fname);
end
load(fname);
use.DataF = SubFread1_ext36;
use.DataR = SubRread1_ext36;

for g=find(indGenes)'
    ch = SGD.chr(g);
    if SGD.watson(g)
        datC = use.DataF{ch};
        stPos = SGD.pos(g,1); enPos = SGD.pos(g,2);
    else
        datC = use.DataR{ch};
        stPos = SGD.pos(g,2); enPos = SGD.pos(g,1);
    end
    
    win5 = (stPos-winHalf):(stPos+winHalf);
    win3 = (enPos-winHalf):(enPos+winHalf);
    
    Covered3conv(g) = all(datC(win3));
    Covered5conv(g) = all(datC(win5));
end
%% print table

cov3c = nansum(Covered3conv);
cov5c = nansum(Covered5conv);
mat = [cov5c; cov3c]./sum(indGenes)*100;

fid = fopen(sprintf('%s.boundariesStats.txt',lib),'w');
fprintf(fid,'Library\t5''_end_covered\t3''_end_covered\t5''_%%\t3''_%%\n');
fprintf(fid,'%s\t%d\t%d\t%.2f\t%.2f\n', lib,cov5c,cov3c,mat(:,1)');
fclose(fid);
    


