function gp_evalStrandSpecLib_1dir(varargin)
%
% -l lib_name 
%
%  COMPILE INSTRUCTIONS:
%       0) use matlab7.5.  There are library installation problems that made this
%       unsuccessful with matlab 7.6  To use matlab 7.5 type 'reuse
%       matlab75' and then 'matlab' at the unix prompt.
%
%       1) run 'mbuild -setup'.  Verify that the mbuildopts.sh that gets
%       installed in ~/.matlab/R2007b references the gcc in /util/gcc-4.1.1
%        (in instances where CC is set to 'gcc', make sure that the gcc is
%        '/util/gcc-4.1.1/bin/gcc'.)
%
%       2) go to the directory where you want to compile and type:
%           mcc -v -m -w enable gp_evalStrandSpecLib_1dir
%
%       3) After compilation, you are ready to execute.  Set the
%       LD_LIBRARY_PATH environment variable by typing:
%           'setenv LD_LIBRARY_PATH
%           /broad/tools/apps/matlab75/sys/os/glnxa64:/broad/tools/apps/ma
%           tlab75/bin/glnxa64:/util/gcc-4.1.1/lib:$LD_LIBRARY_PATH'
%
%       4) execute the compiled binary
%  
%---

% $Id$
% $Date: 2008-08-12 12:35:31 -0400 (Tue, 12 Aug 2008) $
% $LastChangedBy: jdobson $
% $Rev$


if isempty(varargin)
    disp('Usage: gp_evalStrandSpecLib_1 -d dir -s sam_file [-n name]');
    disp('[-f flip_strands] [-g avgGeneStats(def=0)] [-v verbosity_level(def=10)]')
    return
end

a = handle_args({'d','s','n','f','g','v'},varargin);

dir = a.d;
if isempty(dir)
    error('Must have a directory.')
end

sam = a.s;
if isempty(sam)
    error('Must have an input file.')
end

name = a.n;
if isempty(name)
  name='userData';
end

if ~isempty(a.f)
    flip = str2double(a.f);
else
    flip = 0;
end

if ~isempty(a.g)
    avgGeneStats = str2double(a.g);
else
    avgGeneStats = 0;
end

if ~isempty(a.v)
  set_verbose_level(str2double(a.v));
else
  set_verbose_level(10);
end

%% RUN_EVAL

verbose('Parameters:',10)
verbose([      'dir = ' dir],10);
verbose([      'samFile = ' sam],10);
verbose([      'flip = ' num2str(flip)],10);
verbose([      'avgGeneStats = ' num2str(avgGeneStats)],10);

run_evalStrandSpecLib_1dir(dir,sam,avgGeneStats,flip,name);

close all

