function [totalMapped,uniqueStarts] = checkLibraryComplexity_1dir(dir,lib)

%% load data
load(sprintf('%s/SGD.mat',dir));
verbose(sprintf('working on %s\n',lib),20);
fname = sprintf('%s.mat',lib);
if ~exist(fname,'file'),
    error('prog:input','checkLibraryComplexity_1dir: File %s does not exist\n',fname);
end

load(fname,'SubFread1','SubRread1');
useF = SubFread1;
useR = SubRread1;
%% unique on F and R
chrNum = length(useF);
totalMapped = 0;
uniqueStarts = 0;
for c=1:chrNum
    totalMapped = totalMapped + sum(useF{c}) + sum(useR{c});
    uniqueStarts =  uniqueStarts + length(find(useF{c})) + length(find(useR{c}));
end



%% write output
fid = fopen(sprintf('%s.UniqueStarts.txt',lib),'w');
fprintf(fid,'Library\tTotalMapped\tUniqueStarts\n');
fprintf(fid,'%s\t%d\t%d\n',lib,totalMapped,uniqueStarts);
fclose(fid);
