# Run this after running Leukemia2.R

# This is a re-plot of the factors to have the factors in a better visual order (the one shown in the PNAS paper)

program.location    <-  "c:/CGP2006/MPM/Software_and_Examples/MP.Library.R"
source(program.location, verbose=T, max.deparse.length=9999)   # Load molecular signatures function library 

MP.Resort.Rows(
   input.ds = "C:/CGP2006/MPM/Software_and_Examples/Leukemia2/Leukemia2.all.H.gct",
   new.order = c(6, 4, 3, 10, 5, 7, 8, 9, 2, 1),
   new.row.labs = c("F1", "F2", "F3", "F4", "F5", "F6", "F7", "F8", "F9", "F10"),
   new.row.descs =  c("F1", "F2", "F3", "F4", "F5", "F6", "F7", "F8", "F9", "F10"),
   output.ds =  "C:/CGP2006/MPM/Software_and_Examples/Leukemia2/Leukemia2.all.H.resorted.gct")

# Create heat maps again

CLS <- MP.ReadClsFile(file =  "C:/CGP2006/MPM/Software_and_Examples/Leukemia2/Leukemia2.all.cls")
model.size <- length(CLS$class.v)

identifier          <-    "Leukemia2.resorted"
k.proj              <-          10
alg                 <-    "NMF.div"
niter               <-        2000
seed                <-        1234
nchar.phen          <-           9
postprojnorm        <-           T
use.biplot          <-        TRUE
heatmap.row.norm    <-       FALSE
heatmap.cmap.type   <-           6
use.feature.names   <-       FALSE
high.conf.thres     <-        0.30
output.dir          <-       "c:/CGP2006/MPM/Software_and_Examples/Leukemia2/"
kernel              <-     "radial"
cost                <-           1
gamma               <-        0.05
theta               <-        0.05
model.set.refinement <-          T

# D1 = Ross et al ALL, D2 = Ross et al AML, D3 = Yeoh et al , D4 = Chiaretti et al ,
# D5 = Armstrong et al , D6 = Valk et al , D7 = Gutierrez et al , D8 = Bullinger et al , D9 = Bourquin et al

legend.list <- c(
         "green2",  22,             # ALL_BCR          ALL_BCR___D1 *
         "yellow2", 22,             # ALL_E2A          ALL_E2A___D1 *
         "paleturquoise2", 22,      # ALL_MLL          ALL_MLL___D1 *
         "chocolate3", 22,          # ALL_T            ALL_T_____D1 *
         "blue2", 22,               # ALL_TEL          ALL_TEL___D1 *
         "gray60", 22,              # AML_8_21         AML_8_21__D2 *
         "red1", 22,                # AML_15_17        AML_15_17_D2 *
         "steelblue", 22,           # AML_M7,          AML_M7____D2 *
         "darkgreen", 22,           # AML_MLL          AML_MLL___D2 *
         "purple1", 22,             # AML_inv16        AML_inv16_D2 *
     # test sets   
         "green2",  21,             # ALL_BCR           ALL_BCR___D10 *
         "yellow2", 23,             # ALL_E2A           ALL_E2A___D3 *
         "paleturquoise2", 24,      # ALL_MLL           ALL_MLL___D5 *
         "paleturquoise4", 21,      # ALL_MLL           ALL_MLL___D10 *
         "chocolate3", 25,          # ALL_T             ALL_T_____D4 *
         "chocolate4", 21,          # ALL_T             ALL_T_____D3 *
         "blue2", 23,               # ALL_TEL           ALL_TEL___D3 *
         "blue4", 21,               # ALL_TEL           ALL_TEL___D10 *
         "gray60", 24,              # AML_8_21          AML_8_21__D8 *
         "gray40", 25,              # AML_8_21          AML_8_21__D6 *
         "red1", 21,                # AML_15_17         AML_15_17_D7 *
         "red3", 23,                # AML_15_17         AML_15_17_D6 *
         "red4", 24,                # AML_15_17         AML_15_17_D8 *
         "steelblue", 25,           # AML_M7            AML_M7____D9 *
         "darkgreen", 21,           # AML_MLL           AML_MLL___D6 *
         "purple1", 23,             # AML_inv16         AML_inv16_D7 *
         "orchid", 24,              # AML_inv16         AML_inv16_D6 *
         "purple4", 25,             # AML_inv16         AML_inv16_D8 *
         ) 
         
symbol.scaling <- 0.55
col <- legend.list[seq(1, length(legend.list), 2)]
symbs <- as.numeric(legend.list[seq(2, length(legend.list), 2)])


O <- MP.Projection.Plots(
        input.ds =                    "C:/CGP2006/MPM/Software_and_Examples/Leukemia2/Leukemia2.all.H.resorted.gct",
        input.cls =                   "C:/CGP2006/MPM/Software_and_Examples/Leukemia2/Leukemia2.all.H.cls",
        model.set =                   seq(1, model.size),
        output.2D.proj.plot =         paste(output.dir, identifier, ".2D.proj", sep=""),
        output.heatmap.plot =         paste(output.dir, identifier, ".heatmap", sep=""),
        output.heatmap.sorted.plot =  paste(output.dir, identifier, ".heatmap.sorted", sep=""),
        use.biplot =                  use.biplot,
        title =                       identifier,
        seed =                        seed, 
        heatmap.row.norm =            heatmap.row.norm,
        heatmap.cmap.type =           heatmap.cmap.type,
        symbol.scaling =              symbol.scaling,
        col =                         col,
        symbs =                       symbs)

